<?php
// download.php
// Usage:
//  - View inline:  download.php?id=123
//  - Force download: download.php?id=123&action=download

session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo "Forbidden: not logged in.";
    exit;
}

$mysqli = new mysqli("localhost", "root", "", "powerbi_demo");
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo "Server error: DB connection failed.";
    exit;
}

$userId = (int)$_SESSION['user_id'];
$fileId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$action = (isset($_GET['action']) && $_GET['action'] === 'download') ? 'download' : 'inline';

if ($fileId <= 0) {
    http_response_code(400);
    echo "Bad request: missing or invalid id.";
    exit;
}

// Fetch file record and ensure it is assigned to the logged-in user
$stmt = $mysqli->prepare("SELECT file_name, assigned_user_id FROM assign_user WHERE id = ? LIMIT 1");
if (!$stmt) {
    http_response_code(500);
    echo "Server error (prepare failed).";
    exit;
}
$stmt->bind_param("i", $fileId);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$row) {
    http_response_code(404);
    echo "Not found: file record missing.";
    exit;
}

// Authorization: must be assigned to current user
if ((int)$row['assigned_user_id'] !== $userId) {
    http_response_code(403);
    echo "Forbidden: this file is not assigned to you.";
    exit;
}

$filename = $row['file_name'];

// Resolve uploads directory and target file path safely
$uploadsDir = realpath(__DIR__ . '/uploads');
if ($uploadsDir === false) {
    http_response_code(500);
    echo "Server error: uploads directory missing.";
    exit;
}

$targetPath = realpath(__DIR__ . '/uploads/' . $filename);
if ($targetPath === false || strpos($targetPath, $uploadsDir) !== 0) {
    http_response_code(404);
    echo "Not found: invalid file path.";
    exit;
}

if (!is_file($targetPath) || !is_readable($targetPath)) {
    http_response_code(404);
    echo "Not found: file not available on disk.";
    exit;
}

// Serve file as text/html (adjust if you allow other types)
$basename = basename($targetPath);
// Minimal mime detection for .html/.htm — you can extend as needed
$ext = strtolower(pathinfo($basename, PATHINFO_EXTENSION));
$mime = ($ext === 'htm' || $ext === 'html') ? 'text/html' : 'application/octet-stream';

header('Content-Type: ' . $mime);
if ($action === 'download') {
    header('Content-Disposition: attachment; filename="' . $basename . '"');
} else {
    header('Content-Disposition: inline; filename="' . $basename . '"');
}

// Optional: prevent caching (uncomment if desired)
// header('Cache-Control: no-cache, no-store, must-revalidate');
// header('Pragma: no-cache');
// header('Expires: 0');

readfile($targetPath);
exit;
