<?php
session_start();
$mysqli = new mysqli("localhost","root","","powerbi_demo");
if ($mysqli->connect_errno) die("DB error: " . $mysqli->connect_error);

if (isset($_POST['login'])) {
    $username = trim($_POST['username']); // here user enters email
    $password = $_POST['password'];

    $stmt = $mysqli->prepare("SELECT id, username, email, password, role FROM users WHERE email = ? LIMIT 1");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if ($res && password_verify($password, $res['password'])) {
        session_regenerate_id(true);
        $_SESSION['user_id'] = (int)$res['id'];
        $_SESSION['username'] = $res['username'] ?? $res['email'];
        $_SESSION['role'] = $res['role'] ?? 'user';

        // Redirect based on role
        if ($_SESSION['role'] === 'admin') {
            header("Location: upload.php");
        } else {
            header("Location: view.php");
        }
        exit;
    } else {
        $error = "Invalid username or password";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DustValue - Lead Management Software</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <style>
        #particles-js {
            position: absolute;
            width: 100%;
            height: 100%;
            background-color: #000;
            z-index: -1;
        }
        .card-3d {
            transform-style: preserve-3d;
            transition: all 0.5s ease;
        }
        .card-3d:hover {
            transform: rotateY(10deg) rotateX(5deg) translateY(-10px);
            box-shadow: 0 20px 30px rgba(255, 0, 0, 0.3);
        }
    </style>
</head>
<body class="min-h-screen flex flex-col items-center justify-center bg-black text-white overflow-hidden">
    <!-- Particle.js Background -->
    <div id="particles-js"></div>
    
    <!-- Header -->
    <header class="text-center mb-12 z-10" id="header">
        <h1 class="text-5xl font-bold mb-2 text-red-600">DustValue Report</h1>
       <!--  <p class="text-xl text-gray-300">Domain, Server, Doc, Link</p> -->
    </header>
    
    <!-- Login Container -->
    <div class="flex flex-col items-center z-10" id="login-section">
        <div class="card-3d bg-gradient-to-br from-gray-900 to-black p-8 rounded-lg shadow-2xl border border-red-900 w-80">
            <div class="text-center mb-6">
                <div class="w-16 h-16 bg-red-900 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-red-500">Login</h2>
               <!--  <p class="text-gray-400 mt-2">Only <b>@dustvalue.com</b> emails allowed</p> -->
            </div>
            <form method="post" class="space-y-4">
                <div>
                    <input type="email" id="username" name="username" placeholder="you@dustvalue.com"
                        class="w-full bg-gray-800 border border-gray-700 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-red-500"
                        required autocomplete="off">
                </div>

                <div>
                    <input type="password" id="password" name="password" placeholder="*********"
                        class="w-full bg-gray-800 border border-gray-700 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-red-500"
                        required autocomplete="off">
                </div>
                <button name="login"
                    class="w-full bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded transition duration-300 transform hover:scale-105">
                    Login
                </button>
                <p id="login-error" class="text-red-400 text-center text-sm pt-2" style="display:none"></p>
            </form>
        </div>
    </div>

    <!-- Dashboard -->
    <div class="flex flex-col items-center z-10" id="dashboard-section" style="display:none;">
        <div class="bg-gradient-to-br from-gray-900 to-black p-8 rounded-lg shadow-2xl border border-red-900 w-[350px] min-h-[260px] flex flex-col items-center">
            <h2 class="text-3xl font-bold text-green-400 mb-2">Welcome, <span id="user-email"></span>!</h2>
            <p class="text-lg text-gray-300 mb-4">This is your dashboard.</p>
            <div class="flex flex-col gap-3 w-full">
                <a href="#" class="block bg-gray-800 hover:bg-red-600 text-white py-2 px-4 rounded text-center transition">Domains & Servers</a>
                <a href="#" class="block bg-gray-800 hover:bg-red-600 text-white py-2 px-4 rounded text-center transition">Documentation</a>
                <a href="#" class="block bg-gray-800 hover:bg-red-600 text-white py-2 px-4 rounded text-center transition">Team Links</a>
            </div>
            <button onclick="logout()" class="mt-6 bg-red-500 hover:bg-red-700 px-4 py-2 rounded text-white font-bold">Logout</button>
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="mt-12 text-gray-500 text-sm z-10">
        © 2025 DustValue - All Rights Reserved
    </footer>
</body>
</html>

