<?php
// logout.php
// Securely destroy session and redirect to login page with a message.

// start session if not already
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Clear all session variables
$_SESSION = [];

// If session cookie exists, delete it
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $params["path"] ?? '/',
        $params["domain"] ?? '',
        $params["secure"] ?? false,
        $params["httponly"] ?? true
    );
}

// Finally destroy the session
@session_destroy();

// Optionally ensure session cookie name cleared
setcookie(session_name(), '', time() - 3600, '/');

// Redirect back to login with a friendly query flag
$redirect = 'login.php?msg=loggedout';

// If headers aren't sent, use PHP redirect
if (!headers_sent()) {
    header('Location: ' . $redirect);
    exit;
}

// Fallback HTML (for rare cases headers already sent)
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Logged out — CorePHP</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <meta http-equiv="refresh" content="2;url=<?php echo htmlspecialchars($redirect); ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: linear-gradient(180deg,#f7fbff,#eef6ff); height:100vh; display:flex; align-items:center; justify-content:center; font-family:Inter,system-ui,-apple-system; }
    .card { border-radius:12px; padding:24px; text-align:center; box-shadow:0 12px 40px rgba(2,6,23,0.06); }
    .emoji { font-size:44px; }
    a.btn { margin-top:12px; }
  </style>
</head>
<body>
  <div class="card">
    <div class="emoji">👋</div>
    <h4 class="mt-2">You are logged out</h4>
    <p class="text-muted mb-3">Redirecting to the login page…</p>
    <a href="<?php echo htmlspecialchars($redirect); ?>" class="btn btn-primary">Go to Login Now</a>
  </div>

  <script>
    // double-check redirect after 1.5s
    setTimeout(function(){ windo
